"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeployAgentPolicyModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmDeployAgentPolicyModal = ({
  onConfirm,
  onCancel,
  agentCount,
  agentPolicies,
  agentPoliciesToAdd = [],
  agentPoliciesToRemove = []
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalTitle",
      defaultMessage: "Save and deploy changes"
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalCancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalConfirmButtonLabel",
      defaultMessage: "Save and deploy changes"
    }),
    buttonColor: "primary"
  }, agentCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.fleet.agentPolicy.confirmModalCalloutTitle', {
      defaultMessage: 'This action will update {agentCount, plural, one {# agent} other {# agents}}',
      values: {
        agentCount
      }
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalCalloutDescription",
    defaultMessage: "Fleet has detected that the selected agent policies, {policyNames}, are already in use by some of your agents. As a result of this action, Fleet will deploy updates to all agents that use these policies.",
    values: {
      policyNames: /*#__PURE__*/_react.default.createElement("b", null, agentPolicies.map(policy => policy.name).join(', '))
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "confirmAddRemovePoliciesCallout",
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.fleet.agentPolicy.confirmModalPoliciesCalloutTitle', {
      defaultMessage: 'This action will update the selected agent policies',
      values: {
        agentCount
      }
    })
  }, agentPoliciesToAdd.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalPoliciesAddCalloutDescription",
    defaultMessage: "Agent policies that will be updated to use this integration policy:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, agentPoliciesToAdd.map(policy => /*#__PURE__*/_react.default.createElement("li", {
    key: policy
  }, policy)))), agentPoliciesToRemove.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalPoliciesRemoveCalloutDescription",
    defaultMessage: "Agent policies that will be updated to remove this integration policy:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, agentPoliciesToRemove.map(policy => /*#__PURE__*/_react.default.createElement("li", {
    key: policy
  }, policy))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalDescription",
    defaultMessage: "This action can not be undone. Are you sure you wish to continue?"
  }));
};
exports.ConfirmDeployAgentPolicyModal = ConfirmDeployAgentPolicyModal;