"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstallFleetServerStep = getInstallFleetServerStep;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _ = require("../..");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInstallFleetServerStep({
  isFleetServerReady,
  disabled,
  serviceToken,
  fleetServerHost,
  fleetServerPolicyId,
  deploymentMode
}) {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.installFleetServerTitle', {
      defaultMessage: 'Install Fleet Server to a centralized host'
    }),
    status: disabled ? 'disabled' : isFleetServerReady ? 'complete' : 'incomplete',
    children: !disabled && /*#__PURE__*/_react.default.createElement(InstallFleetServerStepContent, {
      serviceToken: serviceToken,
      fleetServerHost: fleetServerHost,
      fleetServerPolicyId: fleetServerPolicyId,
      deploymentMode: deploymentMode
    })
  };
}
const InstallFleetServerStepContent = ({
  serviceToken,
  fleetServerHost,
  fleetServerPolicyId,
  deploymentMode
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const kibanaVersion = (0, _hooks.useKibanaVersion)();
  const {
    output
  } = (0, _hooks.useDefaultOutput)();
  const {
    downloadSource
  } = (0, _hooks.useDefaultDownloadSource)();
  const commandOutput = (output === null || output === void 0 ? void 0 : output.type) === 'elasticsearch' ? output : undefined;
  const installCommands = ['linux', 'mac', 'windows', 'deb', 'rpm'].reduce((acc, platform) => {
    var _commandOutput$hosts$, _commandOutput$hosts, _commandOutput$ca_tru;
    acc[platform] = (0, _utils.getInstallCommandForPlatform)(platform, (_commandOutput$hosts$ = commandOutput === null || commandOutput === void 0 ? void 0 : (_commandOutput$hosts = commandOutput.hosts) === null || _commandOutput$hosts === void 0 ? void 0 : _commandOutput$hosts[0]) !== null && _commandOutput$hosts$ !== void 0 ? _commandOutput$hosts$ : '<ELASTICSEARCH_HOST>', serviceToken !== null && serviceToken !== void 0 ? serviceToken : '', fleetServerPolicyId, fleetServerHost, deploymentMode === 'production', (_commandOutput$ca_tru = commandOutput === null || commandOutput === void 0 ? void 0 : commandOutput.ca_trusted_fingerprint) !== null && _commandOutput$ca_tru !== void 0 ? _commandOutput$ca_tru : undefined, kibanaVersion, downloadSource);
    return acc;
  }, {});
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.installFleetServerInstructions",
    defaultMessage: "Install Fleet Server agent on a centralized host so that other hosts you wish to monitor can connect to it. In production, we recommend using one or more dedicated hosts. For additional guidance, see our {installationLink}.",
    values: {
      installationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: docLinks.links.fleet.installElasticAgent
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.enrollmentInstructions.installationMessage.link",
        defaultMessage: "installation docs"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_.PlatformSelector, {
    linuxCommand: installCommands.linux,
    macCommand: installCommands.mac,
    windowsCommand: installCommands.windows,
    linuxDebCommand: installCommands.deb,
    linuxRpmCommand: installCommands.rpm,
    k8sCommand: installCommands.kubernetes,
    hasK8sIntegration: false,
    hasK8sIntegrationMultiPage: false,
    hasFleetServer: true
  }));
};