"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetServerHost = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
var _use_fleet_server_host_form = require("../../../sections/settings/components/fleet_server_hosts_flyout/use_fleet_server_host_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFleetServerHost = () => {
  var _fleetServerHost$is_p;
  const [fleetServerHost, setFleetServerHost] = (0, _react.useState)();
  const [isFleetServerHostSubmitted, setIsFleetServerHostSubmitted] = (0, _react.useState)(false);
  const isPreconfigured = (_fleetServerHost$is_p = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.is_preconfigured) !== null && _fleetServerHost$is_p !== void 0 ? _fleetServerHost$is_p : false;
  const nameInput = (0, _hooks.useInput)('', _use_fleet_server_host_form.validateName, isPreconfigured);
  const isDefaultInput = (0, _hooks.useSwitchInput)(false, isPreconfigured || (fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.is_default));
  const hostUrlsInput = (0, _hooks.useComboInput)('hostUrls', [], _use_fleet_server_host_form.validateFleetServerHosts, isPreconfigured);
  const inputs = (0, _react.useMemo)(() => ({
    nameInput,
    isDefaultInput,
    hostUrlsInput
  }), [nameInput, isDefaultInput, hostUrlsInput]);
  const validate = (0, _react.useCallback)(() => (0, _hooks.validateInputs)(inputs), [inputs]);
  const {
    data,
    resendRequest: refreshGetFleetServerHosts
  } = (0, _hooks.useGetFleetServerHosts)();
  const fleetServerHosts = (0, _react.useMemo)(() => {
    var _data$items;
    return (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [];
  }, [data === null || data === void 0 ? void 0 : data.items]);
  const setDefaultInputValue = isDefaultInput.setValue;
  (0, _react.useEffect)(() => {
    const defaultHost = fleetServerHosts.find(item => item.is_default === true);
    if (defaultHost) {
      setFleetServerHost(defaultHost);
      setDefaultInputValue(false);
    } else {
      setFleetServerHost(null);
      setDefaultInputValue(true);
    }
  }, [fleetServerHosts, setDefaultInputValue]);
  const handleSubmitForm = (0, _react.useCallback)(async () => {
    if (!validate()) {
      return;
    }
    setIsFleetServerHostSubmitted(false);
    const newFleetServerHost = {
      name: inputs.nameInput.value,
      host_urls: inputs.hostUrlsInput.value,
      is_default: inputs.isDefaultInput.value
    };
    const res = await (0, _hooks.sendPostFleetServerHost)(newFleetServerHost);
    if (res.error) {
      throw res.error;
    }
    if (!res.data) {
      throw new Error('No data');
    }
    await refreshGetFleetServerHosts();
    setIsFleetServerHostSubmitted(true);
    setFleetServerHost(res.data.item);
    return res.data.item;
  }, [validate, refreshGetFleetServerHosts, inputs.nameInput.value, inputs.hostUrlsInput.value, inputs.isDefaultInput.value]);
  return {
    fleetServerHosts,
    handleSubmitForm,
    fleetServerHost,
    isFleetServerHostSubmitted,
    setFleetServerHost,
    inputs
  };
};
exports.useFleetServerHost = useFleetServerHost;