"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInheritedNamespace = getInheritedNamespace;
exports.policyHasAPMIntegration = policyHasAPMIntegration;
exports.policyHasEndpointSecurity = policyHasEndpointSecurity;
exports.policyHasFleetServer = policyHasFleetServer;
exports.policyHasSyntheticsIntegration = policyHasSyntheticsIntegration;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function policyHasFleetServer(agentPolicy) {
  var _agentPolicy$package_;
  if (!agentPolicy.package_policies) {
    return false;
  }
  return ((_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.some(p => {
    var _p$package;
    return ((_p$package = p.package) === null || _p$package === void 0 ? void 0 : _p$package.name) === _constants.FLEET_SERVER_PACKAGE;
  })) || !!agentPolicy.has_fleet_server;
}
function policyHasAPMIntegration(agentPolicy) {
  return policyHasIntegration(agentPolicy, _constants.FLEET_APM_PACKAGE);
}
function policyHasSyntheticsIntegration(agentPolicy) {
  return policyHasIntegration(agentPolicy, _constants.FLEET_SYNTHETICS_PACKAGE);
}
function policyHasEndpointSecurity(agentPolicy) {
  return policyHasIntegration(agentPolicy, _constants.FLEET_ENDPOINT_PACKAGE);
}
function policyHasIntegration(agentPolicy, packageName) {
  var _agentPolicy$package_2;
  if (!agentPolicy.package_policies) {
    return false;
  }
  return (_agentPolicy$package_2 = agentPolicy.package_policies) === null || _agentPolicy$package_2 === void 0 ? void 0 : _agentPolicy$package_2.some(p => {
    var _p$package2;
    return ((_p$package2 = p.package) === null || _p$package2 === void 0 ? void 0 : _p$package2.name) === packageName;
  });
}
function getInheritedNamespace(agentPolicies) {
  if (agentPolicies.length === 1) {
    return agentPolicies[0].namespace;
  }
  return 'default';
}