"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ecs = require("@elastic/ecs");
var _fields_metadata_client = require("./fields_metadata_client");
var _ecs_fields_repository = require("./repositories/ecs_fields_repository");
var _integration_fields_repository = require("./repositories/integration_fields_repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "integrationFieldsExtractor", () => Promise.resolve({}));
    this.logger = logger;
  }
  setup() {
    return {
      registerIntegrationFieldsExtractor: extractor => {
        this.integrationFieldsExtractor = extractor;
      }
    };
  }
  start() {
    const {
      logger,
      integrationFieldsExtractor
    } = this;
    const ecsFieldsRepository = _ecs_fields_repository.EcsFieldsRepository.create({
      ecsFields: _ecs.EcsFlat
    });
    const integrationFieldsRepository = _integration_fields_repository.IntegrationFieldsRepository.create({
      integrationFieldsExtractor
    });
    return {
      getClient() {
        return _fields_metadata_client.FieldsMetadataClient.create({
          logger,
          ecsFieldsRepository,
          integrationFieldsRepository
        });
      }
    };
  }
}
exports.FieldsMetadataService = FieldsMetadataService;