"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HashedCache = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lruCache = _interopRequireDefault(require("lru-cache"));
var _objectHash = _interopRequireDefault(require("object-hash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class HashedCache {
  constructor(options = {
    max: 500
  }) {
    (0, _defineProperty2.default)(this, "cache", void 0);
    this.cache = new _lruCache.default(options);
  }
  get(key) {
    const serializedKey = this.getHashedKey(key);
    return this.cache.get(serializedKey);
  }
  set(key, value) {
    const serializedKey = this.getHashedKey(key);
    return this.cache.set(serializedKey, value);
  }
  has(key) {
    const serializedKey = this.getHashedKey(key);
    return this.cache.has(serializedKey);
  }
  reset() {
    return this.cache.reset();
  }
  getHashedKey(key) {
    return (0, _objectHash.default)(key, {
      unorderedArrays: true
    });
  }
}
exports.HashedCache = HashedCache;