"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partialFieldMetadataPlainRT = exports.multiFieldRT = exports.fieldSourceRT = exports.fieldMetadataPlainRT = exports.fieldAttributeRT = exports.allowedValueRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldSourceRT = exports.fieldSourceRT = rt.keyof({
  ecs: null,
  integration: null,
  unknown: null
});
const allowedValueRT = exports.allowedValueRT = rt.intersection([rt.type({
  description: rt.string,
  name: rt.string
}), rt.partial({
  expected_event_types: rt.array(rt.string),
  beta: rt.string
})]);
const multiFieldRT = exports.multiFieldRT = rt.type({
  flat_name: rt.string,
  name: rt.string,
  type: rt.string
});
const requiredBaseMetadataPlainRT = rt.type({
  name: rt.string
});
const optionalBaseMetadataPlainRT = rt.partial(requiredBaseMetadataPlainRT.props);
const optionalMetadataPlainRT = rt.partial({
  allowed_values: rt.array(allowedValueRT),
  beta: rt.string,
  dashed_name: rt.string,
  description: rt.string,
  doc_values: rt.boolean,
  example: rt.unknown,
  expected_values: rt.array(rt.string),
  flat_name: rt.string,
  format: rt.string,
  ignore_above: rt.number,
  index: rt.boolean,
  input_format: rt.string,
  level: rt.string,
  multi_fields: rt.array(multiFieldRT),
  normalize: rt.array(rt.string),
  object_type: rt.string,
  original_fieldset: rt.string,
  output_format: rt.string,
  output_precision: rt.number,
  pattern: rt.string,
  required: rt.boolean,
  scaling_factor: rt.number,
  short: rt.string,
  source: fieldSourceRT,
  type: rt.string
});
const partialFieldMetadataPlainRT = exports.partialFieldMetadataPlainRT = rt.intersection([optionalBaseMetadataPlainRT, optionalMetadataPlainRT]);
const fieldMetadataPlainRT = exports.fieldMetadataPlainRT = rt.intersection([requiredBaseMetadataPlainRT, optionalMetadataPlainRT]);
const fieldAttributeRT = exports.fieldAttributeRT = rt.union([rt.keyof(requiredBaseMetadataPlainRT.props), rt.keyof(optionalMetadataPlainRT.props)]);