"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.converter = void 0;
exports.ddToDMS = ddToDMS;
exports.ddToMGRS = ddToMGRS;
exports.ddToUTM = ddToUTM;
exports.mgrsToDD = mgrsToDD;
exports.mgrstoUSNG = mgrstoUSNG;
exports.utmToDD = utmToDD;
exports.withinRange = withinRange;
var usng = _interopRequireWildcard(require("usng.js"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore
const converter = exports.converter = new usng.Converter();
function withinRange(value, min, max) {
  const isInvalid = value === '' || value > max || value < min;
  const error = isInvalid ? _i18n.i18n.translate('fieldFormats.geoUtils.outOfRangeErrorMsg', {
    defaultMessage: `Must be between {min} and {max}`,
    values: {
      min,
      max
    }
  }) : null;
  return {
    isInvalid,
    error
  };
}
function ddToUTM(lat, lon) {
  try {
    const utm = converter.LLtoUTM(lat, lon);
    return {
      northing: utm === converter.UNDEFINED_STR ? '' : String(Math.round(utm.northing)),
      easting: utm === converter.UNDEFINED_STR ? '' : String(Math.round(utm.easting)),
      zone: utm === converter.UNDEFINED_STR ? '' : `${utm.zoneNumber}${converter.UTMLetterDesignator(lat)}`
    };
  } catch (e) {
    return {
      northing: '',
      easting: '',
      zone: ''
    };
  }
}
function utmToDD(northing, easting, zoneNumber) {
  try {
    return converter.UTMtoLL(northing, easting, zoneNumber);
  } catch (e) {
    return undefined;
  }
}
function ddToDMS(lat, lon) {
  const southing = lat < 0;
  const westing = lon < 0;
  lat = Math.abs(lat);
  const lathours = parseInt(lat.toString(), 10).toString();
  const latmins = parseInt((lat % 1 * 60).toString(), 10).toString();
  const latsec = parseInt((lat % 1 * 60 % 1 * 60).toString(), 10).toString();
  const lats = lathours.padStart(2, '0') + latmins.padStart(2, '0') + latsec.padStart(2, '0') + (southing ? 'S' : 'N');
  lon = Math.abs(lon);
  const lonhours = parseInt(lon.toString(), 10).toString();
  const lonmins = parseInt((lon % 1 * 60).toString(), 10).toString();
  const lonsec = parseInt((lon % 1 * 60 % 1 * 60).toString(), 10).toString();
  const lons = lonhours.padStart(3, '0') + lonmins.padStart(2, '0') + lonsec.padStart(2, '0') + (westing ? 'W' : 'E');
  return `${lats},${lons}`;
}
function ddToMGRS(lat, lon) {
  try {
    const mgrsCoord = converter.LLtoMGRS(lat, lon, 5);
    return mgrsCoord;
  } catch (e) {
    return '';
  }
}
function mgrstoUSNG(mgrs) {
  let squareIdEastSpace = 0;
  for (let i = mgrs.length - 1; i > -1; i--) {
    // check if we have hit letters yet
    if (isNaN(parseInt(mgrs.substr(i, 1), 10))) {
      squareIdEastSpace = i + 1;
      break;
    }
  }
  const gridZoneSquareIdSpace = squareIdEastSpace ? squareIdEastSpace - 2 : -1;
  const numPartLength = mgrs.substr(squareIdEastSpace).length / 2;
  // add the number split space
  const eastNorthSpace = squareIdEastSpace ? squareIdEastSpace + numPartLength : -1;
  const stringArray = mgrs.split('');
  stringArray.splice(eastNorthSpace, 0, ' ');
  stringArray.splice(squareIdEastSpace, 0, ' ');
  stringArray.splice(gridZoneSquareIdSpace, 0, ' ');
  const rejoinedArray = stringArray.join('');
  return rejoinedArray;
}
function mgrsToDD(mgrs) {
  try {
    return converter.USNGtoLL(mgrstoUSNG(mgrs));
  } catch (e) {
    return undefined;
  }
}