"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DURATION_OUTPUT_FORMATS = exports.DURATION_INPUT_FORMATS = exports.DEFAULT_DURATION_OUTPUT_FORMAT = exports.DEFAULT_DURATION_INPUT_FORMAT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_INPUT_FORMAT = {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.seconds', {
    defaultMessage: 'Seconds'
  }),
  kind: 'seconds'
};
const inputFormats = [{
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.picoseconds', {
    defaultMessage: 'Picoseconds'
  }),
  kind: 'picoseconds'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.nanoseconds', {
    defaultMessage: 'Nanoseconds'
  }),
  kind: 'nanoseconds'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.microseconds', {
    defaultMessage: 'Microseconds'
  }),
  kind: 'microseconds'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.milliseconds', {
    defaultMessage: 'Milliseconds'
  }),
  kind: 'milliseconds'
}, {
  ...DEFAULT_INPUT_FORMAT
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.minutes', {
    defaultMessage: 'Minutes'
  }),
  kind: 'minutes'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.hours', {
    defaultMessage: 'Hours'
  }),
  kind: 'hours'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.days', {
    defaultMessage: 'Days'
  }),
  kind: 'days'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.weeks', {
    defaultMessage: 'Weeks'
  }),
  kind: 'weeks'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.months', {
    defaultMessage: 'Months'
  }),
  kind: 'months'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.inputFormats.years', {
    defaultMessage: 'Years'
  }),
  kind: 'years'
}];
const DEFAULT_OUTPUT_FORMAT = {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.humanize.approximate', {
    defaultMessage: 'Human-readable (approximate)'
  }),
  method: 'humanize'
};
const outputFormats = [{
  ...DEFAULT_OUTPUT_FORMAT
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.humanize.precise', {
    defaultMessage: 'Human-readable (precise)'
  }),
  method: 'humanizePrecise'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asMilliseconds', {
    defaultMessage: 'Milliseconds'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asMilliseconds.short', {
    defaultMessage: 'ms'
  }),
  method: 'asMilliseconds'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asSeconds', {
    defaultMessage: 'Seconds'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asSeconds.short', {
    defaultMessage: 's'
  }),
  method: 'asSeconds'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asMinutes', {
    defaultMessage: 'Minutes'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asMinutes.short', {
    defaultMessage: 'min'
  }),
  method: 'asMinutes'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asHours', {
    defaultMessage: 'Hours'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asHours.short', {
    defaultMessage: 'h'
  }),
  method: 'asHours'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asDays', {
    defaultMessage: 'Days'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asDays.short', {
    defaultMessage: 'd'
  }),
  method: 'asDays'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asWeeks', {
    defaultMessage: 'Weeks'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asWeeks.short', {
    defaultMessage: 'w'
  }),
  method: 'asWeeks'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asMonths', {
    defaultMessage: 'Months'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asMonths.short', {
    defaultMessage: 'mon'
  }),
  method: 'asMonths'
}, {
  text: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asYears', {
    defaultMessage: 'Years'
  }),
  shortText: _i18n.i18n.translate('fieldFormats.duration.outputFormats.asYears.short', {
    defaultMessage: 'y'
  }),
  method: 'asYears'
}];
const DEFAULT_DURATION_INPUT_FORMAT = exports.DEFAULT_DURATION_INPUT_FORMAT = DEFAULT_INPUT_FORMAT;
const DEFAULT_DURATION_OUTPUT_FORMAT = exports.DEFAULT_DURATION_OUTPUT_FORMAT = DEFAULT_OUTPUT_FORMAT;
const DURATION_INPUT_FORMATS = exports.DURATION_INPUT_FORMATS = inputFormats;
const DURATION_OUTPUT_FORMATS = exports.DURATION_OUTPUT_FORMATS = outputFormats;