"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/core/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privilegeOverrideSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  composedOf: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    feature: _configSchema.schema.string(),
    privileges: _configSchema.schema.arrayOf(_configSchema.schema.string())
  })))
}));
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  overrides: (0, _configSchema.offeringBasedSchema)({
    // Overrides are only exposed in Serverless offering.
    serverless: _configSchema.schema.maybe(
    // Key is the feature ID, value is a set of feature properties to override.
    _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
      hidden: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      name: _configSchema.schema.maybe(_configSchema.schema.string({
        minLength: 1
      })),
      category: _configSchema.schema.maybe(_configSchema.schema.string({
        validate(categoryName) {
          if (!Object.hasOwn(_server.DEFAULT_APP_CATEGORIES, categoryName)) {
            return `Unknown category "${categoryName}". Should be one of ${Object.keys(_server.DEFAULT_APP_CATEGORIES).join(', ')}`;
          }
        }
      })),
      order: _configSchema.schema.maybe(_configSchema.schema.number()),
      privileges: _configSchema.schema.maybe(_configSchema.schema.object({
        all: privilegeOverrideSchema,
        read: privilegeOverrideSchema
      })),
      subFeatures: _configSchema.schema.maybe(_configSchema.schema.object({
        // Key is the ID of the sub-feature privilege, value is a set of privilege properties to override.
        privileges: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
          disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
          includeIn: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('read'), _configSchema.schema.literal('none')]))
        }))
      }))
    })))
  })
});