"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = exports.ExpressionRenderHandler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = _interopRequireWildcard(require("rxjs"));
var Rx = _rxjs;
var _lodash = require("lodash");
var _render_error_handler = require("./render_error_handler");
var _services = require("./services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ExpressionRenderHandler {
  constructor(element, {
    onRenderError,
    renderMode,
    syncColors,
    syncTooltips,
    syncCursor,
    interactive,
    hasCompatibleActions = async () => false,
    getCompatibleCellValueActions = async () => [],
    executionContext
  } = {}) {
    (0, _defineProperty2.default)(this, "render$", void 0);
    (0, _defineProperty2.default)(this, "update$", void 0);
    (0, _defineProperty2.default)(this, "events$", void 0);
    (0, _defineProperty2.default)(this, "element", void 0);
    (0, _defineProperty2.default)(this, "destroyFn", void 0);
    (0, _defineProperty2.default)(this, "renderCount", 0);
    (0, _defineProperty2.default)(this, "renderSubject", void 0);
    (0, _defineProperty2.default)(this, "eventsSubject", void 0);
    (0, _defineProperty2.default)(this, "updateSubject", void 0);
    (0, _defineProperty2.default)(this, "handlers", void 0);
    (0, _defineProperty2.default)(this, "onRenderError", void 0);
    (0, _defineProperty2.default)(this, "render", async (value, uiState) => {
      if (!value || typeof value !== 'object') {
        return this.handleRenderError(new Error('invalid data provided to the expression renderer'));
      }
      if (value.type !== 'render' || !value.as) {
        if (value.type === 'error') {
          return this.handleRenderError(value.error);
        } else {
          return this.handleRenderError(new Error('invalid data provided to the expression renderer'));
        }
      }
      if (!(0, _services.getRenderersRegistry)().get(value.as)) {
        return this.handleRenderError(new Error(`invalid renderer id '${value.as}'`));
      }
      try {
        // Rendering is asynchronous, completed by handlers.done()
        await (0, _services.getRenderersRegistry)().get(value.as).render(this.element, value.value, {
          ...this.handlers,
          uiState
        });
      } catch (e) {
        return this.handleRenderError(e);
      }
    });
    (0, _defineProperty2.default)(this, "destroy", () => {
      this.renderSubject.complete();
      this.eventsSubject.complete();
      this.updateSubject.complete();
      if (this.destroyFn) {
        this.destroyFn();
      }
    });
    (0, _defineProperty2.default)(this, "getElement", () => {
      return this.element;
    });
    (0, _defineProperty2.default)(this, "handleRenderError", error => {
      this.onRenderError(this.element, error, this.handlers);
    });
    this.element = element;
    this.eventsSubject = new Rx.Subject();
    this.events$ = this.eventsSubject.asObservable();
    this.onRenderError = onRenderError || _render_error_handler.renderErrorHandler;
    this.renderSubject = new Rx.BehaviorSubject(null);
    this.render$ = this.renderSubject.asObservable().pipe((0, _rxjs.filter)(_lodash.isNumber));
    this.updateSubject = new Rx.Subject();
    this.update$ = this.updateSubject.asObservable();
    this.handlers = {
      onDestroy: fn => {
        this.destroyFn = fn;
      },
      done: () => {
        this.renderCount++;
        this.renderSubject.next(this.renderCount);
      },
      reload: () => {
        this.updateSubject.next(null);
      },
      getExecutionContext() {
        return executionContext;
      },
      update: params => {
        this.updateSubject.next(params);
      },
      event: data => {
        this.eventsSubject.next(data);
      },
      getRenderMode: () => {
        return renderMode || 'view';
      },
      isSyncColorsEnabled: () => {
        return syncColors || false;
      },
      isSyncTooltipsEnabled: () => {
        return syncTooltips || false;
      },
      isSyncCursorEnabled: () => {
        return syncCursor || true;
      },
      isInteractive: () => {
        return interactive !== null && interactive !== void 0 ? interactive : true;
      },
      hasCompatibleActions,
      getCompatibleCellValueActions
    };
  }
}
exports.ExpressionRenderHandler = ExpressionRenderHandler;
const render = async (element, data, options) => {
  const handler = new ExpressionRenderHandler(element, options);
  handler.render(data);
  return handler;
};
exports.render = render;