"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionsPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _services = require("./services");
var _react_expression_renderer_wrapper = require("./react_expression_renderer_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Expressions public setup contract, extends {@link ExpressionsServiceSetup}
 */

/**
 * Expressions public start contrect, extends {@link ExpressionServiceStart}
 */

class ExpressionsPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "expressions", new _services.ExpressionsService({
      logger: ExpressionsPublicPlugin.logger
    }));
  }
  setup(core) {
    const {
      expressions
    } = this;
    const {
      renderers
    } = expressions;
    (0, _services.setRenderersRegistry)(renderers);
    (0, _services.setExpressionsService)(expressions);
    const setup = expressions.setup((0, _lodash.pick)(core, 'getStartServices'));
    return Object.freeze(setup);
  }
  start(core) {
    (0, _services.setNotifications)(core.notifications);
    const {
      expressions
    } = this;
    const loader = async (element, expression, params) => {
      const {
        ExpressionLoader
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./loader')));
      return new ExpressionLoader(element, expression, params);
    };
    const render = async (element, data, options) => {
      const {
        ExpressionRenderHandler
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./render')));
      const handler = new ExpressionRenderHandler(element, options);
      handler.render(data);
      return handler;
    };
    const start = {
      ...expressions.start(),
      loader,
      render,
      ReactExpressionRenderer: _react_expression_renderer_wrapper.ReactExpressionRenderer
    };
    return Object.freeze(start);
  }
  stop() {
    this.expressions.stop();
  }
}
exports.ExpressionsPublicPlugin = ExpressionsPublicPlugin;
(0, _defineProperty2.default)(ExpressionsPublicPlugin, "logger", {
  ...console,
  // eslint-disable-next-line no-console
  fatal: console.error,
  get() {
    return this;
  },
  isLevelEnabled: () => true
});