"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loader = exports.ExpressionLoader = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _render = require("./render");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ExpressionLoader {
  constructor(element, _expression, _params) {
    (0, _defineProperty2.default)(this, "data$", void 0);
    (0, _defineProperty2.default)(this, "update$", void 0);
    (0, _defineProperty2.default)(this, "render$", void 0);
    (0, _defineProperty2.default)(this, "events$", void 0);
    (0, _defineProperty2.default)(this, "loading$", void 0);
    (0, _defineProperty2.default)(this, "execution", void 0);
    (0, _defineProperty2.default)(this, "renderHandler", void 0);
    (0, _defineProperty2.default)(this, "dataSubject", void 0);
    (0, _defineProperty2.default)(this, "loadingSubject", void 0);
    (0, _defineProperty2.default)(this, "data", void 0);
    (0, _defineProperty2.default)(this, "params", {});
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "loadData", (expression, params) => {
      var _this$subscription;
      (_this$subscription = this.subscription) === null || _this$subscription === void 0 ? void 0 : _this$subscription.unsubscribe();
      if (this.execution && this.execution.isPending) {
        this.execution.cancel();
      }
      this.setParams(params);
      this.execution = (0, _services.getExpressionsService)().execute(expression, params.context, {
        searchContext: params.searchContext,
        variables: params.variables || {},
        inspectorAdapters: params.inspectorAdapters,
        searchSessionId: params.searchSessionId,
        debug: params.debug,
        syncColors: params.syncColors,
        syncCursor: params === null || params === void 0 ? void 0 : params.syncCursor,
        syncTooltips: params.syncTooltips,
        executionContext: params.executionContext,
        partial: params.partial,
        throttle: params.throttle,
        allowCache: params.allowCache
      });
      this.subscription = this.execution.getData()
      // delaying until the next tick since we execute the expression in the constructor
      .pipe((0, _rxjs.delay)(0)).subscribe(value => this.dataSubject.next(value));
    });
    this.dataSubject = new _rxjs.Subject();
    this.data$ = this.dataSubject.asObservable();
    this.loadingSubject = new _rxjs.BehaviorSubject(false);
    // loading is a "hot" observable,
    // as loading$ could emit straight away in the constructor
    // and we want to notify subscribers about it, but all subscriptions will happen later
    this.loading$ = this.loadingSubject.asObservable().pipe((0, _rxjs.shareReplay)(1), (0, _rxjs.filter)(_ => _ === true), (0, _rxjs.map)(() => void 0));
    this.renderHandler = new _render.ExpressionRenderHandler(element, {
      interactive: _params === null || _params === void 0 ? void 0 : _params.interactive,
      onRenderError: _params && _params.onRenderError,
      renderMode: _params === null || _params === void 0 ? void 0 : _params.renderMode,
      syncColors: _params === null || _params === void 0 ? void 0 : _params.syncColors,
      syncTooltips: _params === null || _params === void 0 ? void 0 : _params.syncTooltips,
      syncCursor: _params === null || _params === void 0 ? void 0 : _params.syncCursor,
      hasCompatibleActions: _params === null || _params === void 0 ? void 0 : _params.hasCompatibleActions,
      getCompatibleCellValueActions: _params === null || _params === void 0 ? void 0 : _params.getCompatibleCellValueActions,
      executionContext: _params === null || _params === void 0 ? void 0 : _params.executionContext
    });
    this.render$ = this.renderHandler.render$;
    this.update$ = this.renderHandler.update$;
    this.events$ = this.renderHandler.events$;
    this.update$.subscribe(value => {
      if (value) {
        const {
          newExpression,
          newParams
        } = value;
        this.update(newExpression, newParams);
      }
    });
    this.data$.subscribe(({
      result
    }) => {
      this.render(result);
    });
    this.render$.subscribe(() => {
      this.loadingSubject.next(false);
    });
    this.setParams(_params);
    if (_expression) {
      this.loadingSubject.next(true);
      this.loadData(_expression, this.params);
    }
  }
  destroy() {
    var _this$subscription2;
    this.dataSubject.complete();
    this.loadingSubject.complete();
    this.renderHandler.destroy();
    this.cancel();
    (_this$subscription2 = this.subscription) === null || _this$subscription2 === void 0 ? void 0 : _this$subscription2.unsubscribe();
  }
  cancel() {
    var _this$execution;
    (_this$execution = this.execution) === null || _this$execution === void 0 ? void 0 : _this$execution.cancel();
  }
  getExpression() {
    var _this$execution2;
    return (_this$execution2 = this.execution) === null || _this$execution2 === void 0 ? void 0 : _this$execution2.getExpression();
  }
  getAst() {
    var _this$execution3;
    return (_this$execution3 = this.execution) === null || _this$execution3 === void 0 ? void 0 : _this$execution3.getAst();
  }
  getElement() {
    return this.renderHandler.getElement();
  }
  inspect() {
    var _this$execution4;
    return (_this$execution4 = this.execution) === null || _this$execution4 === void 0 ? void 0 : _this$execution4.inspect();
  }
  update(expression, params) {
    this.setParams(params);
    this.loadingSubject.next(true);
    if (expression) {
      this.loadData(expression, this.params);
    } else if (this.data) {
      this.render(this.data);
    }
  }
  render(data) {
    this.renderHandler.render(data, this.params.uiState);
  }
  setParams(params) {
    var _params$throttle, _this$execution5;
    if (!params || !Object.keys(params).length) {
      return;
    }
    if (params.searchContext) {
      this.params.searchContext = (0, _lodash.defaults)({}, params.searchContext, this.params.searchContext || {});
    }
    if (params.uiState && this.params) {
      this.params.uiState = params.uiState;
    }
    if (params.variables && this.params) {
      this.params.variables = params.variables;
    }
    if (params.searchSessionId && this.params) {
      this.params.searchSessionId = params.searchSessionId;
    }
    this.params.syncColors = params.syncColors;
    this.params.syncCursor = params.syncCursor;
    this.params.syncTooltips = params.syncTooltips;
    this.params.debug = Boolean(params.debug);
    this.params.partial = Boolean(params.partial);
    this.params.throttle = Number((_params$throttle = params.throttle) !== null && _params$throttle !== void 0 ? _params$throttle : 1000);
    this.params.allowCache = params.allowCache;
    this.params.inspectorAdapters = params.inspectorAdapters || ((_this$execution5 = this.execution) === null || _this$execution5 === void 0 ? void 0 : _this$execution5.inspect());
    this.params.executionContext = params.executionContext;
  }
}
exports.ExpressionLoader = ExpressionLoader;
const loader = async (element, expression, params) => {
  return new ExpressionLoader(element, expression, params);
};
exports.loader = loader;