"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilteredLayers = getFilteredLayers;
exports.getLayersTitles = exports.getLayersFormats = exports.getLayerTitles = exports.getLayerFormats = void 0;
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _format2 = require("./format");
var _visualization = require("./visualization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFilteredLayers(layers) {
  return layers.filter(layer => {
    let table;
    let accessors = [];
    let xAccessor;
    let splitAccessors = [];
    if ((0, _visualization.isDataLayer)(layer) || (0, _visualization.isReferenceLayer)(layer)) {
      table = layer.table;
      accessors = layer.accessors;
    }
    if ((0, _visualization.isDataLayer)(layer)) {
      var _layer$splitAccessors;
      xAccessor = layer.xAccessor !== undefined && table ? (0, _utils.getAccessorByDimension)(layer.xAccessor, table.columns) : undefined;
      splitAccessors = table ? ((_layer$splitAccessors = layer.splitAccessors) === null || _layer$splitAccessors === void 0 ? void 0 : _layer$splitAccessors.map(splitAccessor => (0, _utils.getAccessorByDimension)(splitAccessor, table.columns))) || [] : [];
    }
    return !(!accessors.length || !table || table.rows.length === 0 || xAccessor && table.rows.every(row => xAccessor && row[xAccessor] === undefined) ||
    // stacked percentage bars have no xAccessors but splitAccessor with undefined values in them when empty
    !xAccessor && splitAccessors.length && table.rows.every(row => splitAccessors.every(splitAccessor => row[splitAccessor] === undefined)));
  });
}
const getAccessorWithFieldFormat = (dimension, columns) => {
  if (!dimension) {
    return {};
  }
  const accessor = (0, _utils.getAccessorByDimension)(dimension, columns);
  return {
    [accessor]: (0, _format2.getFormat)(columns, dimension)
  };
};
const getYAccessorWithFieldFormat = (dimension, columns, isPercentage) => {
  var _getFormat, _format;
  if (!dimension) {
    return {};
  }
  const accessor = (0, _utils.getAccessorByDimension)(dimension, columns);
  let format = (_getFormat = (0, _format2.getFormat)(columns, dimension)) !== null && _getFormat !== void 0 ? _getFormat : {
    id: 'number'
  };
  if (((_format = format) === null || _format === void 0 ? void 0 : _format.id) !== 'percent' && isPercentage) {
    format = {
      id: 'percent',
      params: {
        pattern: '0.[00]%'
      }
    };
  }
  return {
    [accessor]: format
  };
};
const getLayerFormats = ({
  xAccessor,
  accessors,
  splitAccessors = [],
  table,
  isPercentage
}, {
  splitColumnAccessor,
  splitRowAccessor
}, formatFactory) => {
  const yAccessors = accessors;
  const splitColumnAccessors = splitAccessors;
  return {
    xAccessors: getAccessorWithFieldFormat(xAccessor, table.columns),
    yAccessors: yAccessors.reduce((formatters, a) => ({
      ...formatters,
      ...getYAccessorWithFieldFormat(a, table.columns, isPercentage)
    }), {}),
    splitSeriesAccessors: splitColumnAccessors === null || splitColumnAccessors === void 0 ? void 0 : splitColumnAccessors.reduce((formatters, splitAccessor) => {
      const formatObj = getAccessorWithFieldFormat(splitAccessor, table.columns);
      const accessor = Object.keys(formatObj)[0];
      formatters[accessor] = {
        format: formatObj[accessor],
        formatter: formatFactory(formatObj[accessor])
      };
      return formatters;
    }, {}),
    splitColumnAccessors: getAccessorWithFieldFormat(splitColumnAccessor, table.columns),
    splitRowAccessors: getAccessorWithFieldFormat(splitRowAccessor, table.columns)
  };
};
exports.getLayerFormats = getLayerFormats;
const getLayersFormats = (layers, splitAccessors, formatFactory) => layers.reduce((formatters, layer) => ({
  ...formatters,
  [layer.layerId]: getLayerFormats(layer, splitAccessors, formatFactory)
}), {});
exports.getLayersFormats = getLayersFormats;
const getTitleForYAccessor = (layerId, yAccessor, groups, columns) => {
  var _column$name;
  const column = (0, _utils.getColumnByAccessor)(yAccessor, columns);
  const axisGroup = groups.find(group => group.series.some(({
    accessor,
    layer
  }) => accessor === yAccessor && layer === layerId));
  return (_column$name = column === null || column === void 0 ? void 0 : column.name) !== null && _column$name !== void 0 ? _column$name : axisGroup === null || axisGroup === void 0 ? void 0 : axisGroup.title;
};
const getLayerTitles = ({
  xAccessor,
  accessors,
  splitAccessors = [],
  table,
  layerId,
  markSizeAccessor
}, {
  splitColumnAccessor,
  splitRowAccessor
}, {
  xTitle
}, groups) => {
  const mapTitle = dimension => {
    if (!dimension) {
      return {};
    }
    const column = (0, _utils.getColumnByAccessor)(dimension, table.columns);
    return {
      [column.id]: column.name
    };
  };
  const getYTitle = accessor => ({
    [accessor]: getTitleForYAccessor(layerId, accessor, groups, table.columns)
  });
  const xColumnId = xAccessor ? (0, _utils.getAccessorByDimension)(xAccessor, table.columns) : undefined;
  const yColumnIds = accessors.map(a => (0, _utils.getAccessorByDimension)(a, table.columns));
  const splitColumnAccessors = splitAccessors;
  return {
    xTitles: xTitle && xColumnId ? {
      [xColumnId]: xTitle
    } : mapTitle(xColumnId),
    yTitles: yColumnIds.reduce((titles, yAccessor) => ({
      ...titles,
      ...(yAccessor ? getYTitle(yAccessor) : {})
    }), {}),
    splitSeriesTitles: splitColumnAccessors.reduce((titles, splitAccessor) => ({
      ...titles,
      ...(splitAccessor ? mapTitle(splitAccessor) : {})
    }), {}),
    markSizeTitles: mapTitle(markSizeAccessor),
    splitColumnTitles: mapTitle(splitColumnAccessor),
    splitRowTitles: mapTitle(splitRowAccessor)
  };
};
exports.getLayerTitles = getLayerTitles;
const getLayersTitles = (layers, splitAccessors, customTitles, groups) => layers.reduce((formatters, layer) => ({
  ...formatters,
  [layer.layerId]: getLayerTitles(layer, splitAccessors, customTitles, groups)
}), {});
exports.getLayersTitles = getLayersTitles;