"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndValue = getEndValue;
exports.getFitEnum = getFitEnum;
exports.getFitOptions = getFitOptions;
var _charts = require("@elastic/charts");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFitEnum(fittingFunction) {
  if (fittingFunction) {
    return _charts.Fit[fittingFunction];
  }
  return _charts.Fit.None;
}
function getEndValue(endValue) {
  if (endValue === _constants.EndValues.NEAREST) {
    return _charts.Fit[endValue];
  }
  if (endValue === _constants.EndValues.ZERO) {
    return 0;
  }
  return undefined;
}
function getFitOptions(fittingFunction, endValue) {
  return {
    type: getFitEnum(fittingFunction),
    endValue: getEndValue(endValue)
  };
}