"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorSeriesAccessorFn = getColorSeriesAccessorFn;
var _coloring = require("@kbn/coloring");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Return a color accessor function for XY charts depending on the split accessors received.
 */
function getColorSeriesAccessorFn(config, getPaletteFn, isDarkMode, mappingData, fieldId, specialTokens) {
  // inverse map to handle the conversion between the formatted string and their original format
  // for any specified special tokens
  const specialHandlingInverseMap = new Map([...specialTokens.entries()].map(d => [d[1], d[0]]));
  const getColor = (0, _coloring.getColorFactory)(config, getPaletteFn, isDarkMode, mappingData);
  return ({
    splitAccessors
  }) => {
    const splitValue = splitAccessors.get(fieldId);
    // if there isn't a category associated in the split accessor, let's use the default color
    if (splitValue === undefined) {
      return null;
    }

    // category can be also a number, range, ip, multi-field. We need to stringify it to be sure
    // we can correctly match it a with user string
    // if the separator exist, we de-construct it into a multifieldkey into values.
    const categories = `${splitValue}`.split(_common.MULTI_FIELD_KEY_SEPARATOR).map(category => {
      var _specialHandlingInver;
      return (_specialHandlingInver = specialHandlingInverseMap.get(category)) !== null && _specialHandlingInver !== void 0 ? _specialHandlingInver : category;
    });
    // we must keep the array nature of a multi-field key or just use a single string
    // This is required because the rule stored are checked differently for single values or multi-values
    return getColor(categories.length > 1 ? categories : categories[0]);
  };
}