"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.layeredXyVisFunction = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _common_xy_args = require("./common_xy_args");
var _i18n2 = require("../i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const layeredXyVisFunction = exports.layeredXyVisFunction = {
  name: _constants.LAYERED_XY_VIS,
  type: 'render',
  inputTypes: ['datatable'],
  help: _i18n2.strings.getXYHelp(),
  args: {
    ..._common_xy_args.commonXYArgs,
    layers: {
      types: [_constants.EXTENDED_DATA_LAYER, _constants.REFERENCE_LINE_LAYER, _constants.REFERENCE_LINE],
      help: _i18n.i18n.translate('expressionXY.layeredXyVis.layers.help', {
        defaultMessage: 'Layers of visual series'
      }),
      multi: true
    },
    annotations: {
      types: ['event_annotations_result'],
      help: _i18n.i18n.translate('expressionXY.layeredXyVis.annotations.help', {
        defaultMessage: 'Annotations'
      })
    },
    splitColumnAccessor: {
      types: ['vis_dimension', 'string'],
      help: _i18n2.strings.getSplitColumnAccessorHelp()
    },
    splitRowAccessor: {
      types: ['vis_dimension', 'string'],
      help: _i18n2.strings.getSplitRowAccessorHelp()
    },
    singleTable: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.layeredXyVis.singleTable.help', {
        defaultMessage: 'All layers use the one datatable'
      }),
      default: false
    }
  },
  async fn(data, args, handlers) {
    const {
      layeredXyVisFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./layered_xy_vis_fn')));
    return await layeredXyVisFn(data, args, handlers);
  }
};