"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extendedDataLayerFunction = void 0;
var _constants = require("../constants");
var _i18n = require("../i18n");
var _common_data_layer_args = require("./common_data_layer_args");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const extendedDataLayerFunction = exports.extendedDataLayerFunction = {
  name: _constants.EXTENDED_DATA_LAYER,
  aliases: [],
  type: _constants.EXTENDED_DATA_LAYER,
  help: _i18n.strings.getDataLayerFnHelp(),
  inputTypes: ['datatable'],
  args: {
    ..._common_data_layer_args.commonDataLayerArgs,
    xAccessor: {
      types: ['vis_dimension', 'string'],
      help: _i18n.strings.getXAccessorHelp()
    },
    splitAccessors: {
      types: ['vis_dimension', 'string'],
      help: _i18n.strings.getSplitAccessorHelp(),
      multi: true
    },
    accessors: {
      types: ['vis_dimension', 'string'],
      help: _i18n.strings.getAccessorsHelp(),
      multi: true
    },
    markSizeAccessor: {
      types: ['vis_dimension', 'string'],
      help: _i18n.strings.getMarkSizeAccessorHelp()
    },
    layerId: {
      types: ['string'],
      help: _i18n.strings.getLayerIdHelp()
    }
  },
  async fn(input, args, context) {
    const {
      extendedDataLayerFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./extended_data_layer_fn')));
    return await extendedDataLayerFn(input, args, context);
  }
};