"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.repeatImageRendererFactory = exports.getRepeatImageRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _common = require("@kbn/presentation-util-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionRepeatImage.renderer.repeatImage.displayName', {
    defaultMessage: 'RepeatImage'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionRepeatImage.renderer.repeatImage.helpDescription', {
    defaultMessage: 'Render a basic repeatImage'
  })
};
const getRepeatImageRenderer = (theme$ = _common.defaultTheme$) => () => ({
  name: 'repeatImage',
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      RepeatImageComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/repeat_image_component')));
    const {
      elasticOutline
    } = await (0, _common.getElasticOutline)();
    const settings = {
      ...config,
      image: (0, _common.isValidUrl)(config.image) ? config.image : elasticOutline,
      emptyImage: config.emptyImage || ''
    };
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
      analytics: undefined
    }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
      theme: {
        theme$
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(RepeatImageComponent, (0, _extends2.default)({
      onLoaded: handlers.done
    }, settings, {
      parentNode: domNode
    })))))), domNode);
  }
});
exports.getRepeatImageRenderer = getRepeatImageRenderer;
const repeatImageRendererFactory = core => getRepeatImageRenderer(core.theme.theme$);
exports.repeatImageRendererFactory = repeatImageRendererFactory;