"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGaugeIconByType = void 0;
var _chartIcons = require("@kbn/chart-icons");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getGaugeIconByType = type => ({
  [_common.GaugeShapes.HORIZONTAL_BULLET]: _chartIcons.IconChartHorizontalBullet,
  [_common.GaugeShapes.VERTICAL_BULLET]: _chartIcons.IconChartVerticalBullet,
  [_common.GaugeShapes.SEMI_CIRCLE]: _chartIcons.IconChartGaugeSemiCircle,
  [_common.GaugeShapes.ARC]: _chartIcons.IconChartGaugeArc,
  [_common.GaugeShapes.CIRCLE]: _chartIcons.IconChartGaugeCircle
})[type];
exports.getGaugeIconByType = getGaugeIconByType;