"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDistributionInPercentageColumn = getDistributionInPercentageColumn;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDistributionInPercentageColumn({
  label,
  layerId,
  dataView,
  columnFilter,
  lensFormulaHelper,
  formula,
  format
}) {
  var _lensFormulaHelper$in;
  const yAxisColId = `y-axis-column-${layerId}`;
  let lensFormula = formula !== null && formula !== void 0 ? formula : 'count() / overall_sum(count())';
  if (columnFilter) {
    lensFormula = formula !== null && formula !== void 0 ? formula : `count(kql='${columnFilter}') / overall_sum(count(kql='${columnFilter}'))`;
  }
  const {
    columns
  } = (_lensFormulaHelper$in = lensFormulaHelper === null || lensFormulaHelper === void 0 ? void 0 : lensFormulaHelper.insertOrReplaceFormulaColumn(yAxisColId, {
    formula: lensFormula,
    label,
    format: format === 'percent' || !format ? {
      id: 'percent',
      params: {
        decimals: 0
      }
    } : undefined
  }, {
    columns: {},
    columnOrder: []
  }, dataView)) !== null && _lensFormulaHelper$in !== void 0 ? _lensFormulaHelper$in : {
    columns: {}
  };
  const {
    [yAxisColId]: main,
    ...supportingColumns
  } = columns;
  return {
    main: columns[yAxisColId],
    supportingColumns
  };
}