"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationListingPlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/** @public */

/** @public */
class EventAnnotationListingPlugin {
  setup(core, dependencies) {
    dependencies.visualizations.listingViewRegistry.add({
      title: _i18n.i18n.translate('eventAnnotationListing.listingViewTitle', {
        defaultMessage: 'Annotation groups'
      }),
      id: 'annotations',
      getTableList: async props => {
        const [coreStart, pluginsStart] = await core.getStartServices();
        const eventAnnotationService = await pluginsStart.eventAnnotation.getService();
        const ids = await pluginsStart.dataViews.getIds();
        const dataViews = await Promise.all(ids.map(id => pluginsStart.dataViews.get(id)));
        const services = {
          core: coreStart,
          LensEmbeddableComponent: pluginsStart.lens.EmbeddableComponent,
          savedObjectsTagging: pluginsStart.savedObjectsTagging,
          eventAnnotationService,
          PresentationUtilContextProvider: pluginsStart.presentationUtil.ContextProvider,
          dataViews,
          createDataView: pluginsStart.dataViews.create.bind(pluginsStart.dataViews),
          sessionService: pluginsStart.data.search.session,
          queryInputServices: {
            http: coreStart.http,
            docLinks: coreStart.docLinks,
            notifications: coreStart.notifications,
            uiSettings: coreStart.uiSettings,
            dataViews: pluginsStart.dataViews,
            unifiedSearch: pluginsStart.unifiedSearch,
            data: pluginsStart.data,
            storage: new _public.Storage(localStorage)
          }
        };
        const {
          getTableList
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./get_table_list')));
        return getTableList(props, services);
      }
    });
  }
  start(core, plugins) {
    // nothing to do here
  }
}
exports.EventAnnotationListingPlugin = EventAnnotationListingPlugin;