"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRangeAnnotationConfig = exports.isQueryAnnotationConfig = exports.isManualPointAnnotationConfig = exports.getDefaultQueryAnnotation = exports.getDefaultManualAnnotation = exports.defaultAnnotationRangeColor = exports.defaultAnnotationLabel = exports.defaultAnnotationColor = exports.createCopiedAnnotation = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultAnnotationColor = exports.defaultAnnotationColor = _uiTheme.euiLightVars.euiColorAccent;
// Do not compute it live as dependencies will add tens of Kbs to the plugin
const defaultAnnotationRangeColor = exports.defaultAnnotationRangeColor = `#F04E981A`; // defaultAnnotationColor with opacity 0.1

const isRangeAnnotationConfig = annotation => {
  return Boolean(annotation && (annotation === null || annotation === void 0 ? void 0 : annotation.key.type) === 'range');
};
exports.isRangeAnnotationConfig = isRangeAnnotationConfig;
const isManualPointAnnotationConfig = annotation => {
  return Boolean(annotation && 'timestamp' in (annotation === null || annotation === void 0 ? void 0 : annotation.key));
};
exports.isManualPointAnnotationConfig = isManualPointAnnotationConfig;
const isQueryAnnotationConfig = annotation => {
  return Boolean(annotation && annotation.type === 'query');
};
exports.isQueryAnnotationConfig = isQueryAnnotationConfig;
const createCopiedAnnotation = (newId, timestamp, source) => {
  if (!source) {
    return getDefaultManualAnnotation(newId, timestamp);
  }
  return {
    ...source,
    id: newId
  };
};
exports.createCopiedAnnotation = createCopiedAnnotation;
const defaultAnnotationLabel = exports.defaultAnnotationLabel = _i18n.i18n.translate('eventAnnotationCommon.manualAnnotation.defaultAnnotationLabel', {
  defaultMessage: 'Event'
});
const getDefaultManualAnnotation = (id, timestamp) => ({
  label: defaultAnnotationLabel,
  type: 'manual',
  key: {
    type: 'point_in_time',
    timestamp
  },
  icon: 'triangle',
  id
});
exports.getDefaultManualAnnotation = getDefaultManualAnnotation;
const getDefaultQueryAnnotation = (id, fieldName, timeField) => ({
  filter: {
    type: 'kibana_query',
    query: `${fieldName}: *`,
    language: 'kuery'
  },
  timeField,
  type: 'query',
  key: {
    type: 'point_in_time'
  },
  id,
  label: `${fieldName}: *`
});
exports.getDefaultQueryAnnotation = getDefaultQueryAnnotation;