"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFunctionsToIgnoreForStats = getFunctionsToIgnoreForStats;
exports.getParamAtPosition = getParamAtPosition;
exports.getQueryForFields = getQueryForFields;
exports.getSourcesFromCommands = getSourcesFromCommands;
exports.isAggFunctionUsedAlready = isAggFunctionUsedAlready;
exports.removeQuoteForSuggestedSources = removeQuoteForSuggestedSources;
var _helpers = require("../shared/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function extractFunctionArgs(args) {
  return args.flatMap(arg => (0, _helpers.isAssignment)(arg) ? arg.args[1] : arg).filter(_helpers.isFunctionItem);
}
function checkContent(fn) {
  const fnDef = (0, _helpers.getFunctionDefinition)(fn.name);
  return !!fnDef && fnDef.type === 'agg' || extractFunctionArgs(fn.args).some(checkContent);
}
function isAggFunctionUsedAlready(command, argIndex) {
  if (argIndex < 0) {
    return false;
  }
  const arg = command.args[argIndex];
  return (0, _helpers.isFunctionItem)(arg) ? checkContent(arg) : false;
}
function getFnContent(fn) {
  return [fn.name].concat(extractFunctionArgs(fn.args).flatMap(getFnContent));
}
function getFunctionsToIgnoreForStats(command, argIndex) {
  if (argIndex < 0) {
    return [];
  }
  const arg = command.args[argIndex];
  return (0, _helpers.isFunctionItem)(arg) ? getFnContent(arg) : [];
}

/**
 * Given a function signature, returns the parameter at the given position.
 *
 * Takes into account variadic functions (minParams), returning the last
 * parameter if the position is greater than the number of parameters.
 *
 * @param signature
 * @param position
 * @returns
 */
function getParamAtPosition({
  params,
  minParams
}, position) {
  return params.length > position ? params[position] : minParams ? params[params.length - 1] : null;
}
function getQueryForFields(queryString, commands) {
  // If there is only one source command and it does not require fields, do not
  // fetch fields, hence return an empty string.
  return commands.length === 1 && ['from', 'row', 'show'].includes(commands[0].name) ? '' : queryString;
}
function getSourcesFromCommands(commands, sourceType) {
  var _fromCommand$args;
  const fromCommand = commands.find(({
    name
  }) => name === 'from');
  const args = (_fromCommand$args = fromCommand === null || fromCommand === void 0 ? void 0 : fromCommand.args) !== null && _fromCommand$args !== void 0 ? _fromCommand$args : [];
  const sources = args.filter(arg => arg.sourceType === sourceType);
  return sources.length === 1 ? sources[0] : undefined;
}
function removeQuoteForSuggestedSources(suggestions) {
  return suggestions.map(d => ({
    ...d,
    // "text" -> text
    text: d.text.startsWith('"') && d.text.endsWith('"') ? d.text.slice(1, -1) : d.text
  }));
}