"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commandAutocompleteDefinitions = exports.commaCompleteItem = exports.colonCompleteItem = void 0;
exports.getAssignmentDefinitionCompletitionItem = getAssignmentDefinitionCompletitionItem;
exports.semiColonCompleteItem = exports.pipeCompleteItem = exports.listCompleteItem = exports.getNextTokenForNot = exports.getBuiltinCompatibleFunctionDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _builtin = require("../definitions/builtin");
var _helpers = require("../shared/helpers");
var _factories = require("./factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getAssignmentDefinitionCompletitionItem() {
  const assignFn = _builtin.builtinFunctions.find(({
    name
  }) => name === '=');
  return (0, _factories.getSuggestionBuiltinDefinition)(assignFn);
}
const getNextTokenForNot = (command, option, argType) => {
  const compatibleFunctions = _builtin.builtinFunctions.filter(({
    name,
    supportedCommands,
    supportedOptions,
    ignoreAsSuggestion
  }) => !ignoreAsSuggestion && !/not_/.test(name) && (option ? supportedOptions === null || supportedOptions === void 0 ? void 0 : supportedOptions.includes(option) : supportedCommands.includes(command)));
  if (argType === 'string' || argType === 'any') {
    // suggest IS, LIKE, RLIKE and TRUE/FALSE
    return compatibleFunctions.filter(({
      name
    }) => name === 'like' || name === 'rlike' || name === 'in').map(_factories.getSuggestionBuiltinDefinition);
  }
  if (argType === 'boolean') {
    // suggest IS, NOT and TRUE/FALSE
    return [...compatibleFunctions.filter(({
      name
    }) => name === 'in').map(_factories.getSuggestionBuiltinDefinition), ...(0, _factories.buildConstantsDefinitions)(['true', 'false'])];
  }
  return [];
};
exports.getNextTokenForNot = getNextTokenForNot;
const getBuiltinCompatibleFunctionDefinition = (command, option, argType, returnTypes, {
  skipAssign
} = {}) => {
  const compatibleFunctions = _builtin.builtinFunctions.filter(({
    name,
    supportedCommands,
    supportedOptions,
    signatures,
    ignoreAsSuggestion
  }) => !ignoreAsSuggestion && !/not_/.test(name) && (!skipAssign || name !== '=') && (option ? supportedOptions === null || supportedOptions === void 0 ? void 0 : supportedOptions.includes(option) : supportedCommands.includes(command)) && signatures.some(({
    params
  }) => !params.length || params.some(pArg => pArg.type === argType || pArg.type === 'any')));
  if (!returnTypes) {
    return compatibleFunctions.map(_factories.getSuggestionBuiltinDefinition);
  }
  return compatibleFunctions.filter(mathDefinition => mathDefinition.signatures.some(signature => returnTypes[0] === 'any' || returnTypes.includes(signature.returnType))).map(_factories.getSuggestionBuiltinDefinition);
};
exports.getBuiltinCompatibleFunctionDefinition = getBuiltinCompatibleFunctionDefinition;
const commandAutocompleteDefinitions = exports.commandAutocompleteDefinitions = (0, _helpers.getAllCommands)().map(_factories.getSuggestionCommandDefinition);
function buildCharCompleteItem(label, detail, {
  sortText,
  quoted
} = {
  quoted: false
}) {
  return {
    label,
    text: quoted ? `"${label}"` : label,
    kind: 'Keyword',
    detail,
    sortText
  };
}
const pipeCompleteItem = exports.pipeCompleteItem = buildCharCompleteItem('|', _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.pipeDoc', {
  defaultMessage: 'Pipe (|)'
}), {
  sortText: 'C',
  quoted: false
});
const commaCompleteItem = exports.commaCompleteItem = buildCharCompleteItem(',', _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.commaDoc', {
  defaultMessage: 'Comma (,)'
}), {
  sortText: 'B',
  quoted: false
});
const colonCompleteItem = exports.colonCompleteItem = buildCharCompleteItem(':', _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.colonDoc', {
  defaultMessage: 'Colon (:)'
}), {
  sortText: 'A',
  quoted: true
});
const semiColonCompleteItem = exports.semiColonCompleteItem = buildCharCompleteItem(';', _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.semiColonDoc', {
  defaultMessage: 'Semi colon (;)'
}), {
  sortText: 'A',
  quoted: true
});
const listCompleteItem = exports.listCompleteItem = {
  label: '( ... )',
  text: '( $0 )',
  asSnippet: true,
  kind: 'Operator',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.listDoc', {
    defaultMessage: 'List of items ( ...)'
  }),
  sortText: 'A',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
};