"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLDataGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _cellActions = require("@kbn/cell-actions");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana_services = require("./kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const DataGridLazy = (0, _sharedUxUtility.withSuspense)( /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./data_grid')))));
const ESQLDataGrid = props => {
  const {
    loading,
    value
  } = (0, _useAsync.default)(() => {
    const startServicesPromise = (0, _kibana_services.untilPluginStartServicesReady)();
    return Promise.all([startServicesPromise]);
  }, []);
  const deps = value === null || value === void 0 ? void 0 : value[0];
  if (loading || !deps) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...deps
    }
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: deps.uiActions.getTriggerCompatibleActions
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: 500
    }
  }, /*#__PURE__*/_react.default.createElement(DataGridLazy, (0, _extends2.default)({
    data: deps.data,
    fieldFormats: deps.fieldFormats,
    core: deps.core
  }, props)))));
};
exports.ESQLDataGrid = ESQLDataGrid;