"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.walk = exports.Walker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _Walker;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Walker {
  constructor(options) {
    this.options = options;
  }
  walk(node) {
    if (!node) return;
    if (node instanceof Array) {
      for (const item of node) this.walk(item);
      return;
    }
    switch (node.type) {
      case 'command':
        {
          this.walkCommand(node);
          break;
        }
      default:
        {
          this.walkAstItem(node);
          break;
        }
    }
  }
  walkCommand(node) {
    switch (node.name) {
      default:
        {
          this.walk(node.args);
          break;
        }
    }
  }
  walkAstItem(node) {
    if (node instanceof Array) {
      const list = node;
      for (const item of list) this.walkAstItem(item);
    } else {
      const item = node;
      this.walkSingleAstItem(item);
    }
  }
  walkSingleAstItem(node) {
    var _options$visitSingleA;
    const {
      options
    } = this;
    (_options$visitSingleA = options.visitSingleAstItem) === null || _options$visitSingleA === void 0 ? void 0 : _options$visitSingleA.call(options, node);
    switch (node.type) {
      case 'function':
        {
          this.walkFunction(node);
          break;
        }
      case 'column':
        {
          var _options$visitColumn;
          (_options$visitColumn = options.visitColumn) === null || _options$visitColumn === void 0 ? void 0 : _options$visitColumn.call(options, node);
          break;
        }
      case 'literal':
        {
          var _options$visitLiteral;
          (_options$visitLiteral = options.visitLiteral) === null || _options$visitLiteral === void 0 ? void 0 : _options$visitLiteral.call(options, node);
          break;
        }
    }
  }
  walkFunction(node) {
    var _this$options$visitFu, _this$options;
    (_this$options$visitFu = (_this$options = this.options).visitFunction) === null || _this$options$visitFu === void 0 ? void 0 : _this$options$visitFu.call(_this$options, node);
    const args = node.args;
    const length = args.length;
    for (let i = 0; i < length; i++) {
      const arg = args[i];
      this.walkAstItem(arg);
    }
  }
}
exports.Walker = Walker;
_Walker = Walker;
/**
 * Walks the AST and calls the appropriate visitor functions.
 */
(0, _defineProperty2.default)(Walker, "walk", (node, options) => {
  const walker = new _Walker(options);
  walker.walk(node);
  return walker;
});
/**
 * Walks the AST and extracts all parameter literals.
 *
 * @param node AST node to extract parameters from.
 */
(0, _defineProperty2.default)(Walker, "params", node => {
  const params = [];
  _Walker.walk(node, {
    visitLiteral: param => {
      if (param.literalType === 'param') {
        params.push(param);
      }
    }
  });
  return params;
});
const walk = exports.walk = Walker.walk;