"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPosition = getPosition;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getPosition(token, lastToken) {
  var _ref;
  if (!token || token.start < 0) {
    return {
      min: 0,
      max: 0
    };
  }
  const endFirstToken = token.stop > -1 ? Math.max(token.stop + 1, token.start) : undefined;
  const endLastToken = lastToken === null || lastToken === void 0 ? void 0 : lastToken.stop;
  return {
    min: token.start,
    max: (_ref = endLastToken !== null && endLastToken !== void 0 ? endLastToken : endFirstToken) !== null && _ref !== void 0 ? _ref : Infinity
  };
}