"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAstAndSyntaxErrors = getAstAndSyntaxErrors;
var _antlr = require("antlr4");
var _antlr_error_listener = require("./antlr_error_listener");
var _antlr_facade = require("./antlr_facade");
var _ast_factory = require("./ast_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// These will need to be manually updated whenever the relevant grammar changes.
const SYNTAX_ERRORS_TO_IGNORE = [`SyntaxError: mismatched input '<EOF>' expecting {'explain', 'from', 'meta', 'metrics', 'row', 'show'}`];
function getAstAndSyntaxErrors(text) {
  if (text == null) {
    return {
      ast: [],
      errors: []
    };
  }
  const errorListener = new _antlr_error_listener.ESQLErrorListener();
  const parseListener = new _ast_factory.AstListener();
  const parser = (0, _antlr_facade.getParser)(_antlr.CharStreams.fromString(text), errorListener, parseListener);
  parser[_antlr_facade.ROOT_STATEMENT]();
  const errors = errorListener.getErrors().filter(error => {
    return !SYNTAX_ERRORS_TO_IGNORE.includes(error.message);
  });
  return {
    ...parseListener.getAst(),
    errors
  };
}