"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParser = exports.getLexer = exports.ROOT_STATEMENT = void 0;
var _antlr = require("antlr4");
var _esql_lexer = _interopRequireDefault(require("./antlr/esql_lexer"));
var _esql_parser = _interopRequireDefault(require("./antlr/esql_parser"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ROOT_STATEMENT = exports.ROOT_STATEMENT = 'singleStatement';
const getParser = (inputStream, errorListener, parseListener) => {
  const lexer = getLexer(inputStream, errorListener);
  const tokenStream = new _antlr.CommonTokenStream(lexer);
  const parser = new _esql_parser.default(tokenStream);
  parser.removeErrorListeners();
  parser.addErrorListener(errorListener);
  if (parseListener) {
    // @ts-expect-error the addParseListener API does exist and is documented here
    // https://github.com/antlr/antlr4/blob/dev/doc/listeners.md
    parser.addParseListener(parseListener);
  }
  return parser;
};
exports.getParser = getParser;
const getLexer = (inputStream, errorListener) => {
  const lexer = new _esql_lexer.default(inputStream);
  lexer.removeErrorListeners();
  lexer.addErrorListener(errorListener);
  return lexer;
};
exports.getLexer = getLexer;