"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FormWrapper", {
  enumerable: true,
  get: function () {
    return _form_utils.FormWrapper;
  }
});
exports.useMultiFieldStories = exports.useFieldStories = exports.useArrayStories = exports.helpers = exports.formStories = void 0;
var _form_validation = require("./form_validation");
var _form_de_serializer = require("./form_de_serializer");
var _form_default_value = require("./form_default_value");
var _form_is_modified = require("./form_is_modified");
var _form_global_fields = require("./form_global_fields");
var _form_utils = require("./form_utils");
var _use_field_field_types = require("./use_field_field_types");
var _use_field_change_listeners = require("./use_field_change_listeners");
var _use_array_basic = require("./use_array_basic");
var _use_array_reorder = require("./use_array_reorder");
var _use_array_complex = require("./use_array_complex");
var _use_array_dynamic_data = require("./use_array_dynamic_data");
var _use_multi_field_basic = require("./use_multi_field_basic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const formStories = exports.formStories = {
  Validation: _form_validation.Validation,
  DeSerializer: _form_de_serializer.DeSerializer,
  DefaultValue: _form_default_value.DefaultValue,
  IsModified: _form_is_modified.IsModified,
  GlobalFields: _form_global_fields.GlobalFields
};
const useFieldStories = exports.useFieldStories = {
  UseFieldFieldTypes: _use_field_field_types.FieldTypes,
  UseFieldChangeListeners: _use_field_change_listeners.ChangeListeners
};
const useArrayStories = exports.useArrayStories = {
  UseArrayBasic: _use_array_basic.Basic,
  UseArrayReorder: _use_array_reorder.Reorder,
  UseArrayComplex: _use_array_complex.Complex,
  UseArrayDynamicData: _use_array_dynamic_data.DynamicData
};
const useMultiFieldStories = exports.useMultiFieldStories = {
  UseMultiFieldBasic: _use_multi_field_basic.Basic
};
const helpers = exports.helpers = {
  submitForm: _form_utils.submitForm
};