"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findIllegalCharactersInIndexName = findIllegalCharactersInIndexName;
exports.indexNameBeginsWithPeriod = indexNameBeginsWithPeriod;
exports.indexNameContainsSpaces = indexNameContainsSpaces;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Names beginning with periods are reserved for hidden indices.
function indexNameBeginsWithPeriod(indexName) {
  if (indexName === undefined) {
    return false;
  }
  return indexName[0] === '.';
}
function findIllegalCharactersInIndexName(indexName) {
  const illegalCharacters = _constants.INDEX_ILLEGAL_CHARACTERS_VISIBLE.reduce((chars, char) => {
    if (indexName.includes(char)) {
      chars.push(char);
    }
    return chars;
  }, []);
  return illegalCharacters;
}
function indexNameContainsSpaces(indexName) {
  return indexName.includes(' ');
}