"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKqlFieldNames = getKqlFieldNames;
exports.getKqlFieldNamesFromExpression = getKqlFieldNamesFromExpression;
var _ = require("../../..");
var _node_types = require("../node_types");
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getKqlFieldNamesFromExpression(expression) {
  const node = (0, _.fromKueryExpression)(expression);
  return getKqlFieldNames(node);
}
function getKqlFieldNames(node) {
  if (_node_types.nodeTypes.function.isNode(node)) {
    if (_functions.functions.and.isNode(node) || _functions.functions.or.isNode(node)) {
      return node.arguments.reduce((result, child) => {
        return result.concat(getKqlFieldNames(child));
      }, []);
    } else if (_functions.functions.not.isNode(node) || _functions.functions.exists.isNode(node) || _functions.functions.is.isNode(node) || _functions.functions.nested.isNode(node) || _functions.functions.range.isNode(node)) {
      // For each of these field types, we only need to look at the first argument to determine the fields
      const [fieldNode] = node.arguments;
      return getKqlFieldNames(fieldNode);
    } else {
      throw new Error(`KQL function ${node.function} not supported in getKqlFieldNames`);
    }
  } else if (_node_types.nodeTypes.literal.isNode(node)) {
    if (node.value === null) return [];
    return [`${_node_types.nodeTypes.literal.toElasticsearchQuery(node)}`];
  } else if (_node_types.nodeTypes.wildcard.isNode(node)) {
    return [_node_types.nodeTypes.wildcard.toElasticsearchQuery(node)];
  } else {
    throw new Error(`KQL node type ${node.type} not supported in getKqlFieldNames`);
  }
}