"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KQL_FUNCTION_OR = void 0;
exports.buildNodeParams = buildNodeParams;
exports.isNode = isNode;
exports.toElasticsearchQuery = toElasticsearchQuery;
exports.toKqlExpression = toKqlExpression;
var ast = _interopRequireWildcard(require("../ast"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KQL_FUNCTION_OR = exports.KQL_FUNCTION_OR = 'or';
function isNode(node) {
  return node.function === KQL_FUNCTION_OR;
}
function buildNodeParams(children) {
  return {
    arguments: children
  };
}
function toElasticsearchQuery(node, indexPattern, config = {}, context = {}) {
  const children = node.arguments || [];
  return {
    bool: {
      should: children.map(child => {
        return ast.toElasticsearchQuery(child, indexPattern, config, context);
      }),
      minimum_should_match: 1
    }
  };
}
function toKqlExpression(node) {
  return `(${node.arguments.map(ast.toKqlExpression).join(' OR ')})`;
}