"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMaximumResponseSizeExceededError = isMaximumResponseSizeExceededError;
exports.isRequestAbortedError = isRequestAbortedError;
exports.isResponseError = isResponseError;
exports.isUnauthorizedError = isUnauthorizedError;
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * An unauthorized (401) error returned by elasticsearch
 * @public
 */

/**
 * Checks if the provided `error` is an {@link errors.ResponseError | elasticsearch response error}
 * @public
 */
function isResponseError(error) {
  return error instanceof _elasticsearch.errors.ResponseError;
}

/**
 * Checks if the provided `error` is an {@link UnauthorizedError | elasticsearch unauthorized error}
 * @public
 */
function isUnauthorizedError(error) {
  return isResponseError(error) && error.statusCode === 401;
}

/**
 * Checks if the provided `error` is an {@link errors.RequestAbortedError | elasticsearch request aborted error}
 * @public
 */
function isRequestAbortedError(error) {
  return error instanceof _elasticsearch.errors.RequestAbortedError;
}
function isMaximumResponseSizeExceededError(error) {
  return isRequestAbortedError(error) && error.message.includes('content length');
}