"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityDiscoveryApiKeyType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SO_ENTITY_DISCOVERY_API_KEY_TYPE = 'entity-discovery-api-key';
const EntityDiscoveryApiKeyType = exports.EntityDiscoveryApiKeyType = {
  name: SO_ENTITY_DISCOVERY_API_KEY_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      apiKey: {
        type: 'binary'
      }
    }
  },
  management: {
    importableAndExportable: false,
    displayName: 'Entity discovery API key'
  }
};