"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pingRoute = pingRoute;
var _constants_entities = require("../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function pingRoute({
  router
}) {
  router.get({
    path: `${_constants_entities.ENTITY_API_PREFIX}/ping`,
    validate: false
  }, async (_context, _req, res) => {
    return res.ok({
      body: {
        message: 'Entity Manager OK'
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  });
}