"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _ping = require("./ping");
var _create = require("./entities/create");
var _delete = require("./entities/delete");
var _reset = require("./entities/reset");
var _get = require("./entities/get");
var _check = require("./enablement/check");
var _enable = require("./enablement/enable");
var _disable = require("./enablement/disable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setupRoutes(dependencies) {
  (0, _ping.pingRoute)(dependencies);
  (0, _create.createEntityDefinitionRoute)(dependencies);
  (0, _delete.deleteEntityDefinitionRoute)(dependencies);
  (0, _reset.resetEntityDefinitionRoute)(dependencies);
  (0, _get.getEntityDefinitionRoute)(dependencies);
  (0, _check.checkEntityDiscoveryEnabledRoute)(dependencies);
  (0, _enable.enableEntityDiscoveryRoute)(dependencies);
  (0, _disable.disableEntityDiscoveryRoute)(dependencies);
}