"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityDefinitionRoute = getEntityDefinitionRoute;
var _configSchema = require("@kbn/config-schema");
var _constants_entities = require("../../../common/constants_entities");
var _find_entity_definition = require("../../lib/entities/find_entity_definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEntityDefinitionRoute({
  router
}) {
  router.get({
    path: `${_constants_entities.ENTITY_INTERNAL_API_PREFIX}/definition`,
    validate: {
      query: _configSchema.schema.object({
        page: _configSchema.schema.maybe(_configSchema.schema.number()),
        perPage: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    }
  }, async (context, req, res) => {
    try {
      var _req$query$page, _req$query$perPage;
      const esClient = (await context.core).elasticsearch.client.asCurrentUser;
      const soClient = (await context.core).savedObjects.client;
      const definitions = await (0, _find_entity_definition.findEntityDefinitions)({
        esClient,
        soClient,
        page: (_req$query$page = req.query.page) !== null && _req$query$page !== void 0 ? _req$query$page : 1,
        perPage: (_req$query$perPage = req.query.perPage) !== null && _req$query$perPage !== void 0 ? _req$query$perPage : 10
      });
      return res.ok({
        body: definitions
      });
    } catch (e) {
      return res.customError({
        body: e,
        statusCode: 500
      });
    }
  });
}