"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.EntityManagerServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _manage_index_templates = require("./lib/manage_index_templates");
var _routes = require("./routes");
var _config = require("../common/config");
var _base = require("./templates/components/base");
var _event = require("./templates/components/event");
var _entities_template = require("./templates/entities_template");
var _saved_objects = require("./saved_objects");
var _entity = require("./templates/components/entity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const config = exports.config = {
  schema: _config.configSchema,
  exposeToBrowser: _config.exposeToBrowserConfig
};
class EntityManagerServerPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    this.config = context.config.get();
    this.logger = context.logger.get();
  }
  setup(core, plugins) {
    core.savedObjects.registerType(_saved_objects.entityDefinition);
    core.savedObjects.registerType(_saved_objects.EntityDiscoveryApiKeyType);
    plugins.encryptedSavedObjects.registerType({
      type: _saved_objects.EntityDiscoveryApiKeyType.name,
      attributesToEncrypt: new Set(['apiKey']),
      attributesToIncludeInAAD: new Set(['id', 'name'])
    });
    const router = core.http.createRouter();
    this.server = {
      config: this.config,
      logger: this.logger
    };
    (0, _routes.setupRoutes)({
      router,
      logger: this.logger,
      spaces: plugins.spaces,
      server: this.server
    });
    return {};
  }
  start(core, plugins) {
    if (this.server) {
      this.server.core = core;
      this.server.isServerless = core.elasticsearch.getCapabilities().serverless;
      this.server.security = plugins.security;
      this.server.encryptedSavedObjects = plugins.encryptedSavedObjects;
    }
    const esClient = core.elasticsearch.client.asInternalUser;

    // Install entities component templates and index template
    Promise.all([(0, _manage_index_templates.upsertComponent)({
      esClient,
      logger: this.logger,
      component: _base.entitiesBaseComponentTemplateConfig
    }), (0, _manage_index_templates.upsertComponent)({
      esClient,
      logger: this.logger,
      component: _event.entitiesEventComponentTemplateConfig
    }), (0, _manage_index_templates.upsertComponent)({
      esClient,
      logger: this.logger,
      component: _entity.entitiesEntityComponentTemplateConfig
    })]).then(() => (0, _manage_index_templates.upsertTemplate)({
      esClient,
      logger: this.logger,
      template: _entities_template.entitiesIndexTemplateConfig
    })).catch(() => {});
    return {};
  }
  stop() {}
}
exports.EntityManagerServerPlugin = EntityManagerServerPlugin;