"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsertComponent = upsertComponent;
exports.upsertTemplate = upsertTemplate;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function upsertTemplate({
  esClient,
  template,
  logger
}) {
  try {
    await esClient.indices.putIndexTemplate(template);
  } catch (error) {
    logger.error(`Error updating entity manager index template: ${error.message}`);
    return;
  }
  logger.info(`Entity manager index template is up to date (use debug logging to see what was installed)`);
  logger.debug(`Entity manager index template: ${JSON.stringify(template)}`);
}
async function upsertComponent({
  esClient,
  component,
  logger
}) {
  try {
    await esClient.cluster.putComponentTemplate(component);
  } catch (error) {
    logger.error(`Error updating entity manager component template: ${error.message}`);
    return;
  }
  logger.info(`Entity manager component template is up to date (use debug logging to see what was installed)`);
  logger.debug(`Entity manager component template: ${JSON.stringify(component)}`);
}