"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uninstallBuiltInEntityDefinitions = uninstallBuiltInEntityDefinitions;
exports.uninstallEntityDefinition = uninstallEntityDefinition;
var _delete_entity_definition = require("./delete_entity_definition");
var _delete_ingest_pipeline = require("./delete_ingest_pipeline");
var _find_entity_definition = require("./find_entity_definition");
var _stop_and_delete_transform = require("./stop_and_delete_transform");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function uninstallEntityDefinition({
  definition,
  esClient,
  soClient,
  logger
}) {
  await (0, _stop_and_delete_transform.stopAndDeleteHistoryTransform)(esClient, definition, logger);
  await (0, _stop_and_delete_transform.stopAndDeleteLatestTransform)(esClient, definition, logger);
  await (0, _delete_ingest_pipeline.deleteHistoryIngestPipeline)(esClient, definition, logger);
  await (0, _delete_ingest_pipeline.deleteLatestIngestPipeline)(esClient, definition, logger);
  await (0, _delete_entity_definition.deleteEntityDefinition)(soClient, definition, logger);
}
async function uninstallBuiltInEntityDefinitions({
  esClient,
  soClient,
  logger
}) {
  const definitions = await (0, _find_entity_definition.findEntityDefinitions)({
    soClient,
    esClient,
    builtIn: true
  });
  await Promise.all(definitions.map(async definition => {
    await uninstallEntityDefinition({
      definition,
      esClient,
      soClient,
      logger
    });
  }));
  return definitions;
}