"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateDefinitionCanCreateValidTransformIds = validateDefinitionCanCreateValidTransformIds;
var _entity_definition_id_too_long_error = require("../errors/entity_definition_id_too_long_error");
var _generate_history_transform_id = require("./generate_history_transform_id");
var _generate_latest_transform_id = require("./generate_latest_transform_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSFORM_ID_MAX_LENGTH = 64;
function validateDefinitionCanCreateValidTransformIds(definition) {
  const historyTransformId = (0, _generate_history_transform_id.generateHistoryTransformId)(definition);
  const latestTransformId = (0, _generate_latest_transform_id.generateLatestTransformId)(definition);
  const spareChars = TRANSFORM_ID_MAX_LENGTH - Math.max(historyTransformId.length, latestTransformId.length);
  if (spareChars < 0) {
    throw new _entity_definition_id_too_long_error.EntityDefinitionIdTooLong(`Entity definition ID is too long (max = ${definition.id.length + spareChars}); the resulting transform ID will be invalid`);
  }
}