"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateHistoryMetadataAggregations = generateHistoryMetadataAggregations;
exports.generateLatestMetadataAggregations = generateLatestMetadataAggregations;
var _constants_entities = require("../../../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateHistoryMetadataAggregations(definition) {
  if (!definition.metadata) {
    return {};
  }
  return definition.metadata.reduce((aggs, metadata) => {
    var _metadata$destination, _metadata$limit;
    return {
      ...aggs,
      [`entity.metadata.${(_metadata$destination = metadata.destination) !== null && _metadata$destination !== void 0 ? _metadata$destination : metadata.source}`]: {
        terms: {
          field: metadata.source,
          size: (_metadata$limit = metadata.limit) !== null && _metadata$limit !== void 0 ? _metadata$limit : _constants_entities.ENTITY_DEFAULT_METADATA_LIMIT
        }
      }
    };
  }, {});
}
function generateLatestMetadataAggregations(definition) {
  if (!definition.metadata) {
    return {};
  }
  return definition.metadata.reduce((aggs, metadata) => {
    var _metadata$destination2, _metadata$limit2;
    return {
      ...aggs,
      [`entity.metadata.${metadata.destination}`]: {
        filter: {
          range: {
            'event.ingested': {
              gte: `now-${definition.history.interval.toJSON()}`
            }
          }
        },
        aggs: {
          data: {
            terms: {
              field: (_metadata$destination2 = metadata.destination) !== null && _metadata$destination2 !== void 0 ? _metadata$destination2 : metadata.source,
              size: (_metadata$limit2 = metadata.limit) !== null && _metadata$limit2 !== void 0 ? _metadata$limit2 : _constants_entities.ENTITY_DEFAULT_METADATA_LIMIT
            }
          }
        }
      }
    };
  }, {});
}