"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateLatestTransform = generateLatestTransform;
var _constants_entities = require("../../../../common/constants_entities");
var _generate_metadata_aggregations = require("./generate_metadata_aggregations");
var _generate_latest_ingest_pipeline_id = require("../ingest_pipeline/generate_latest_ingest_pipeline_id");
var _generate_latest_transform_id = require("./generate_latest_transform_id");
var _generate_index_name = require("../helpers/generate_index_name");
var _generate_metric_aggregations = require("./generate_metric_aggregations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateLatestTransform(definition) {
  var _definition$latest$se, _definition$latest, _definition$latest$se2, _definition$latest$se3, _definition$latest2, _definition$latest2$s, _definition$latest$se4, _definition$latest3, _definition$latest3$s;
  return {
    transform_id: (0, _generate_latest_transform_id.generateLatestTransformId)(definition),
    defer_validation: true,
    source: {
      index: `${(0, _generate_index_name.generateHistoryIndexName)(definition)}.*`
    },
    dest: {
      index: (0, _generate_index_name.generateLatestIndexName)(definition),
      pipeline: (0, _generate_latest_ingest_pipeline_id.generateLatestIngestPipelineId)(definition)
    },
    frequency: (_definition$latest$se = (_definition$latest = definition.latest) === null || _definition$latest === void 0 ? void 0 : (_definition$latest$se2 = _definition$latest.settings) === null || _definition$latest$se2 === void 0 ? void 0 : _definition$latest$se2.frequency) !== null && _definition$latest$se !== void 0 ? _definition$latest$se : _constants_entities.ENTITY_DEFAULT_LATEST_FREQUENCY,
    sync: {
      time: {
        field: (_definition$latest$se3 = (_definition$latest2 = definition.latest) === null || _definition$latest2 === void 0 ? void 0 : (_definition$latest2$s = _definition$latest2.settings) === null || _definition$latest2$s === void 0 ? void 0 : _definition$latest2$s.syncField) !== null && _definition$latest$se3 !== void 0 ? _definition$latest$se3 : 'event.ingested',
        delay: (_definition$latest$se4 = (_definition$latest3 = definition.latest) === null || _definition$latest3 === void 0 ? void 0 : (_definition$latest3$s = _definition$latest3.settings) === null || _definition$latest3$s === void 0 ? void 0 : _definition$latest3$s.syncDelay) !== null && _definition$latest$se4 !== void 0 ? _definition$latest$se4 : _constants_entities.ENTITY_DEFAULT_LATEST_SYNC_DELAY
      }
    },
    settings: {
      deduce_mappings: false,
      unattended: true
    },
    pivot: {
      group_by: {
        ['entity.id']: {
          terms: {
            field: 'entity.id'
          }
        },
        ['entity.displayName']: {
          terms: {
            field: 'entity.displayName.keyword'
          }
        },
        ...definition.identityFields.reduce((acc, id) => ({
          ...acc,
          [`entity.identityFields.${id.field}`]: {
            terms: {
              field: `entity.identityFields.${id.field}`,
              missing_bucket: id.optional
            }
          }
        }), {})
      },
      aggs: {
        ...(0, _generate_metric_aggregations.generateLatestMetricAggregations)(definition),
        ...(0, _generate_metadata_aggregations.generateLatestMetadataAggregations)(definition),
        'entity.lastSeenTimestamp': {
          max: {
            field: 'entity.lastSeenTimestamp'
          }
        },
        'entity.firstSeenTimestamp': {
          min: {
            field: '@timestamp'
          }
        }
      }
    }
  };
}