"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateHistoryTransform = generateHistoryTransform;
var _get_elasticsearch_query_or_throw = require("../helpers/get_elasticsearch_query_or_throw");
var _generate_metric_aggregations = require("./generate_metric_aggregations");
var _constants_entities = require("../../../../common/constants_entities");
var _generate_metadata_aggregations = require("./generate_metadata_aggregations");
var _generate_history_transform_id = require("./generate_history_transform_id");
var _generate_history_ingest_pipeline_id = require("../ingest_pipeline/generate_history_ingest_pipeline_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateHistoryTransform(definition) {
  var _definition$history$s, _definition$history$s2, _definition$history$s3, _definition$history$s4, _definition$history$s5, _definition$history$s6;
  const filter = [];
  if (definition.filter) {
    filter.push((0, _get_elasticsearch_query_or_throw.getElasticsearchQueryOrThrow)(definition.filter));
  }
  return {
    transform_id: (0, _generate_history_transform_id.generateHistoryTransformId)(definition),
    defer_validation: true,
    source: {
      index: definition.indexPatterns,
      ...(filter.length > 0 && {
        query: {
          bool: {
            filter
          }
        }
      })
    },
    dest: {
      index: `${_constants_entities.ENTITY_HISTORY_BASE_PREFIX}.noop`,
      pipeline: (0, _generate_history_ingest_pipeline_id.generateHistoryIngestPipelineId)(definition)
    },
    frequency: (_definition$history$s = (_definition$history$s2 = definition.history.settings) === null || _definition$history$s2 === void 0 ? void 0 : _definition$history$s2.frequency) !== null && _definition$history$s !== void 0 ? _definition$history$s : _constants_entities.ENTITY_DEFAULT_HISTORY_FREQUENCY,
    sync: {
      time: {
        field: (_definition$history$s3 = (_definition$history$s4 = definition.history.settings) === null || _definition$history$s4 === void 0 ? void 0 : _definition$history$s4.syncField) !== null && _definition$history$s3 !== void 0 ? _definition$history$s3 : definition.history.timestampField,
        delay: (_definition$history$s5 = (_definition$history$s6 = definition.history.settings) === null || _definition$history$s6 === void 0 ? void 0 : _definition$history$s6.syncDelay) !== null && _definition$history$s5 !== void 0 ? _definition$history$s5 : _constants_entities.ENTITY_DEFAULT_HISTORY_SYNC_DELAY
      }
    },
    settings: {
      deduce_mappings: false,
      unattended: true
    },
    pivot: {
      group_by: {
        ...definition.identityFields.reduce((acc, id) => ({
          ...acc,
          [`entity.identityFields.${id.field}`]: {
            terms: {
              field: id.field,
              missing_bucket: id.optional
            }
          }
        }), {}),
        ['@timestamp']: {
          date_histogram: {
            field: definition.history.timestampField,
            fixed_interval: definition.history.interval.toJSON()
          }
        }
      },
      aggs: {
        ...(0, _generate_metric_aggregations.generateHistoryMetricAggregations)(definition),
        ...(0, _generate_metadata_aggregations.generateHistoryMetadataAggregations)(definition),
        'entity.lastSeenTimestamp': {
          max: {
            field: definition.history.timestampField
          }
        }
      }
    }
  };
}