"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopAndDeleteHistoryTransform = stopAndDeleteHistoryTransform;
exports.stopAndDeleteLatestTransform = stopAndDeleteLatestTransform;
var _retry = require("./helpers/retry");
var _generate_latest_transform_id = require("./transform/generate_latest_transform_id");
var _generate_history_transform_id = require("./transform/generate_history_transform_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stopAndDeleteHistoryTransform(esClient, definition, logger) {
  try {
    const historyTransformId = (0, _generate_history_transform_id.generateHistoryTransformId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.stopTransform({
      transform_id: historyTransformId,
      wait_for_completion: true,
      force: true
    }, {
      ignore: [409, 404]
    }), {
      logger
    });
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.deleteTransform({
      transform_id: historyTransformId,
      force: true
    }, {
      ignore: [404]
    }), {
      logger
    });
  } catch (e) {
    logger.error(`Cannot stop or delete history transform [${definition.id}]`);
    throw e;
  }
}
async function stopAndDeleteLatestTransform(esClient, definition, logger) {
  try {
    const latestTransformId = (0, _generate_latest_transform_id.generateLatestTransformId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.stopTransform({
      transform_id: latestTransformId,
      wait_for_completion: true,
      force: true
    }, {
      ignore: [409, 404]
    }), {
      logger
    });
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.deleteTransform({
      transform_id: latestTransformId,
      force: true
    }, {
      ignore: [404]
    }), {
      logger
    });
  } catch (e) {
    logger.error(`Cannot stop or delete latest transform [${definition.id}]`);
    throw e;
  }
}