"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startTransform = startTransform;
var _retry = require("./helpers/retry");
var _generate_latest_transform_id = require("./transform/generate_latest_transform_id");
var _generate_history_transform_id = require("./transform/generate_history_transform_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function startTransform(esClient, definition, logger) {
  try {
    const historyTransformId = (0, _generate_history_transform_id.generateHistoryTransformId)(definition);
    const latestTransformId = (0, _generate_latest_transform_id.generateLatestTransformId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.startTransform({
      transform_id: historyTransformId
    }, {
      ignore: [409]
    }), {
      logger
    });
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.startTransform({
      transform_id: latestTransformId
    }, {
      ignore: [409]
    }), {
      logger
    });
  } catch (err) {
    logger.error(`Cannot start entity transforms [${definition.id}]: ${err}`);
    throw err;
  }
}