"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveEntityDefinition = saveEntityDefinition;
var _saved_objects = require("../../saved_objects");
var _entity_id_conflict_error = require("./errors/entity_id_conflict_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function saveEntityDefinition(soClient, definition) {
  const response = await soClient.find({
    type: _saved_objects.SO_ENTITY_DEFINITION_TYPE,
    page: 1,
    perPage: 1,
    filter: `${_saved_objects.SO_ENTITY_DEFINITION_TYPE}.attributes.id:(${definition.id})`
  });
  if (response.total === 1) {
    throw new _entity_id_conflict_error.EntityIdConflict(`Entity definition with [${definition.id}] already exists.`, definition);
  }
  await soClient.create(_saved_objects.SO_ENTITY_DEFINITION_TYPE, definition, {
    id: definition.id,
    overwrite: true
  });
  return definition;
}