"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateLatestProcessors = generateLatestProcessors;
var _generate_index_name = require("../helpers/generate_index_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapDestinationToPainless(destination, source) {
  const fieldParts = destination.split('.');
  return fieldParts.reduce((acc, _part, currentIndex, parts) => {
    if (currentIndex + 1 === parts.length) {
      return `${acc}\n  ctx${parts.map(s => `["${s}"]`).join('')} = ctx.entity.metadata.${source}.data.keySet();`;
    }
    return `${acc}\n if(ctx.${parts.slice(0, currentIndex + 1).join('.')} == null)  ctx${parts.slice(0, currentIndex + 1).map(s => `["${s}"]`).join('')} = new HashMap();`;
  }, '');
}
function createMetadataPainlessScript(definition) {
  if (!definition.metadata) {
    return '';
  }
  return definition.metadata.reduce((script, def) => {
    const source = def.source;
    const destination = def.destination || def.source;
    return `${script}if (ctx.entity?.metadata?.${source.replaceAll('.', '?.')}.data != null) {${mapDestinationToPainless(destination, source)}\n}\n`;
  }, '');
}
function generateLatestProcessors(definition, spaceId) {
  return [{
    set: {
      field: 'event.ingested',
      value: '{{{_ingest.timestamp}}}'
    }
  }, {
    set: {
      field: 'entity.type',
      value: definition.type
    }
  }, {
    set: {
      field: 'entity.spaceId',
      value: spaceId
    }
  }, {
    set: {
      field: 'entity.definitionId',
      value: definition.id
    }
  }, ...(definition.staticFields != null ? Object.keys(definition.staticFields).map(field => ({
    set: {
      field,
      value: definition.staticFields[field]
    }
  })) : []), ...(definition.metadata != null ? [{
    script: {
      source: createMetadataPainlessScript(definition)
    }
  }] : []), {
    remove: {
      field: 'entity.metadata',
      ignore_missing: true
    }
  }, {
    set: {
      field: '_index',
      value: `${(0, _generate_index_name.generateLatestIndexName)(definition)}.${spaceId}`
    }
  }];
}